// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Philip Villars - Caliper Corporation - 2003

    // This toolbox illustrates use of the "timer" functions, used to execute
    // a macro on a timed basis.  It opens the tutorial "BESTROUT" map and
    // zooms into a randomly selected city on the map on a "timed" basis.
    
    // The toolbox illustrates:
    // 1. General use of a toolbox and toolbox (dialog box) items.
    // 2. Use of Timers: functions such as CreateTimer() and DestroyTimer().
    // 3. How to update items in a Dialog Box, using UpdateDBox() and the
    //    DBox's Update item.
	// 4. How to implement two separate buttons that 'toggle' from one to
	//    another i.e. 'Pause' and 'Resume'.
    // 5. How to use the Close item to properly exit a Dialog Box.
    // 6. How to zoom a map to a particular record in a map layer.

    // To run this toolbox using the GISDK toolbox:
    // 1. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 2. Compile this toolbox in test mode using the first button (Compile).
    // 3. Run this toolbox by clicking the second button (Test), typing the
    //    dbox name "My Toolbox", clicking the Dialog Box radio button, and
    //    clicking OK.


DBox "My Toolbox" ,,40,13.5 toolbox

   Init do
      shared shared_map1, shared_placename

      INTERVAL = 2.5  //seconds

      int_millisec = RealToInt(INTERVAL * 1000)
      shared_map1 = OpenMap("Tutorial\\locator.map",)
      msg = "Starting a GISDK 'Timer'.  The Timer will execute a macro " +
            "every " + String(INTERVAL) + " seconds"
      ShowMessage(msg)
      frame_text = "This Toolbox oversees a GISDK 'Timer' that runs a " +
                   "macro at timed intervals.  The macro simply " +
                   "zooms to a random city or town in the map.\n" +
                   "Since this is a Toolbox, you can still " +
                   "interact with the the map and all the other " +
                   "tools.  Try it!"
      txt_name = "Initial Map"
	  HideItem("Resume")
	  ShowItem("Pause")
      CreateTimer("Timer A", int_millisec, "macro A")
   endItem

   Text "description" 1,0.5,38,6.0
      framed
	  variable: frame_text
   
   Text "Map Currently Showing:" 5, 7.5, 30 
   
   Text "Place Name" 5, 9, 30
      framed
      variable: txt_name   
   
   Button "Pause" 7,11,10,1.5 do
      HideItem("Pause")
	  ShowItem("Resume")
      DestroyTimer("Timer A")
   endItem

   Button "Resume" 7, 11, 10, 1.5 do
      HideItem("Resume")
	  ShowItem("Pause")
      CreateTimer("Timer A", int_millisec, "macro A")
   endItem
   
   Button "Quit" 22,11,10,1.5 Cancel do RunMacro("CloseUp") endItem

   Close do RunMacro("CloseUp") endItem

   Update do  txt_name = shared_placename  endItem

   Macro "CloseUp" do
      DestroyTimer("Timer A")
      Return()
   endItem

endDBox


Macro "macro A"

   shared shared_map1, shared_placename

   lyr = "Place"

   // Get the minimum value of the ID field in the Place layer
   rh = GetFirstRecord(lyr + "|", {{"ID", "Ascending"}})
   min_id = lyr.ID

   // Get the maximum value of ID
   rh = GetFirstRecord(lyr + "|", {{"ID", "Descending"}})
   max_id = lyr.ID

   rand_id = min_id + R2I((max_id - min_id)*RandomNumber())

   rh = LocateRecord(lyr + "|", "ID", {rand_id}, {{"Exact", "False"}})

   old_layer = GetLayer()    // get the current layer

   SetLayer(lyr)             // set the current layer to be the place layer

   center = GetPoint(RH2ID(rh))  // get the coordinate of the current Place

   SetLayer(old_layer)       // restore the old current layer

   shared_placename = lyr.City + ", " + lyr.State

   CenterMap(shared_map1, center)

   SetScale(shared_map1, 125000)

   RedrawMap(shared_map1)

   UpdateDbox("My Toolbox")

endMacro